using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Reversi
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private Button[,] plansza=new Button[ReversiSilnikAI.planszaSzer,ReversiSilnikAI.planszaWys];
		private ReversiSilnikAI silnik=new ReversiSilnikAI();
		private Color[] kolory={Color.Ivory, Color.Green, Color.Sienna};
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.ListBox listBox2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.LinkLabel linkLabel1;

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//ustalanie rozmiaru przycisku
			int przyciskSzer=this.ClientSize.Width/ReversiSilnikAI.planszaSzer;
			int przyciskWys=this.ClientSize.Height/ReversiSilnikAI.planszaWys;

			//dopasowywanie okna do calkowitej ilosci przyciskow
			int roznicaSzer=(przyciskSzer*ReversiSilnikAI.planszaSzer-this.ClientSize.Width);
			int roznicaWys=(przyciskWys*ReversiSilnikAI.planszaWys-this.ClientSize.Height);
			this.Width+=roznicaSzer+panel1.Width;
			this.Height+=roznicaWys;

			for (int i=0; i<ReversiSilnikAI.planszaSzer; i++)
				for (int j=0; j<ReversiSilnikAI.planszaWys; j++)
					{
					Button pole=new Button();
					pole.SetBounds(i*przyciskSzer,j*przyciskWys,przyciskSzer,przyciskWys);
					pole.Parent=this;
					pole.Click+=new System.EventHandler(this.kliknieciePolaPlanszy);
					plansza[i,j]=pole;
					}

			uzgodnijWygladPlanszy();

			/*
			//test
			silnik.UstawPionek(2,4);
			uzgodnijWygladPlanszy();
			*/
			linkLabel1.Links.Add(0,linkLabel1.Text.Length,"http://www.phys.uni.torun.pl/~jacek");
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.panel1 = new System.Windows.Forms.Panel();
			this.linkLabel1 = new System.Windows.Forms.LinkLabel();
			this.label6 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.listBox2 = new System.Windows.Forms.ListBox();
			this.label2 = new System.Windows.Forms.Label();
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.button1 = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.panel1.SuspendLayout();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.panel1.Controls.Add(this.linkLabel1);
			this.panel1.Controls.Add(this.label6);
			this.panel1.Controls.Add(this.label5);
			this.panel1.Controls.Add(this.label4);
			this.panel1.Controls.Add(this.label3);
			this.panel1.Controls.Add(this.listBox2);
			this.panel1.Controls.Add(this.label2);
			this.panel1.Controls.Add(this.listBox1);
			this.panel1.Controls.Add(this.button1);
			this.panel1.Controls.Add(this.label1);
			this.panel1.Dock = System.Windows.Forms.DockStyle.Right;
			this.panel1.Location = new System.Drawing.Point(208, 0);
			this.panel1.Name = "panel1";
			this.panel1.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.panel1.Size = new System.Drawing.Size(128, 319);
			this.panel1.TabIndex = 0;
			// 
			// linkLabel1
			// 
			this.linkLabel1.ActiveLinkColor = System.Drawing.SystemColors.ControlText;
			this.linkLabel1.LinkColor = System.Drawing.SystemColors.ControlText;
			this.linkLabel1.Location = new System.Drawing.Point(8, 280);
			this.linkLabel1.Name = "linkLabel1";
			this.linkLabel1.Size = new System.Drawing.Size(112, 16);
			this.linkLabel1.TabIndex = 9;
			this.linkLabel1.TabStop = true;
			this.linkLabel1.Text = "Jacek Matulewski";
			this.linkLabel1.VisitedLinkColor = System.Drawing.SystemColors.ControlText;
			this.linkLabel1.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.linkLabel1_LinkClicked);
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(80, 256);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(32, 16);
			this.label6.TabIndex = 8;
			this.label6.Text = "2";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(80, 240);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(32, 16);
			this.label5.TabIndex = 7;
			this.label5.Text = "2";
			// 
			// label4
			// 
			this.label4.ForeColor = System.Drawing.Color.Sienna;
			this.label4.Location = new System.Drawing.Point(8, 256);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(56, 16);
			this.label4.TabIndex = 6;
			this.label4.Text = "Brzowy";
			// 
			// label3
			// 
			this.label3.ForeColor = System.Drawing.Color.Green;
			this.label3.Location = new System.Drawing.Point(8, 240);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(48, 16);
			this.label3.TabIndex = 5;
			this.label3.Text = "Zielony";
			// 
			// listBox2
			// 
			this.listBox2.BackColor = System.Drawing.SystemColors.Control;
			this.listBox2.ForeColor = System.Drawing.Color.Sienna;
			this.listBox2.ItemHeight = 16;
			this.listBox2.Location = new System.Drawing.Point(64, 112);
			this.listBox2.Name = "listBox2";
			this.listBox2.Size = new System.Drawing.Size(48, 116);
			this.listBox2.TabIndex = 4;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 88);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(96, 16);
			this.label2.TabIndex = 3;
			this.label2.Text = "Ostatnie ruchy:";
			// 
			// listBox1
			// 
			this.listBox1.BackColor = System.Drawing.SystemColors.Control;
			this.listBox1.ForeColor = System.Drawing.Color.Green;
			this.listBox1.ItemHeight = 16;
			this.listBox1.Location = new System.Drawing.Point(8, 112);
			this.listBox1.Name = "listBox1";
			this.listBox1.Size = new System.Drawing.Size(48, 116);
			this.listBox1.TabIndex = 2;
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(40, 32);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(40, 40);
			this.button1.TabIndex = 1;
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(96, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Nastpny ruch:";
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(336, 319);
			this.Controls.Add(this.panel1);
			this.Name = "WinForm";
			this.Text = "Reversi";
			this.panel1.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm());
		}

		void uzgodnijWygladPlanszy()
		{
			for (int i=0; i<ReversiSilnikAI.planszaSzer; i++)
				for (int j=0; j<ReversiSilnikAI.planszaWys; j++)
					{
					//plansza[i,j].Text=silnik.StanPola(i,j).ToString();
					plansza[i,j].BackColor=kolory[silnik.StanPola(i,j)];
					}

			//this.Text="Nastpny ruch gracz nr "+silnik.NumerGraczaWykonujacegoNastepnyRuch();
			button1.BackColor=kolory[silnik.NumerGraczaWykonujacegoNastepnyRuch()];
		}


		void kliknieciePolaPlanszy(object sender,EventArgs e)
		{
			//szukamy odpowiedniego pola planszy
			int kliknietePoziomo=-1,kliknietePionowo=-1;
			for(int poziomo=0;poziomo<ReversiSilnikAI.planszaSzer;poziomo++)
				for(int pionowo=0;pionowo<ReversiSilnikAI.planszaWys;pionowo++)
					if (sender==plansza[poziomo,pionowo])
						{
						kliknietePoziomo=poziomo;
						kliknietePionowo=pionowo;
						}

			//jezeli nie znaleziony - zglaszanie bledu
			if (kliknietePoziomo==-1 || kliknietePionowo==-1)
				throw new Exception("Nie zidentyfikowane pole planszy");

			//wykonanie ruchu
			int zapamietanyNumerGracza=silnik.NumerGraczaWykonujacegoNastepnyRuch();
			if (silnik.UstawPionek(kliknietePoziomo,kliknietePionowo))
				{
				uzgodnijWygladPlanszy();
				//listBox1.Items.Add(""+zapamietanyNumerGracza+": "+kliknietePoziomo+", "+kliknietePionowo);
				switch(zapamietanyNumerGracza)
					{
					case 1: listBox1.Items.Add(ReversiSilnikAI.SymbolPola(kliknietePoziomo,kliknietePionowo)); break;
					case 2: listBox2.Items.Add(ReversiSilnikAI.SymbolPola(kliknietePoziomo,kliknietePionowo)); break;
					}
				listBox1.SelectedIndex=listBox1.Items.Count-1;
				listBox2.SelectedIndex=listBox2.Items.Count-1;
				}

			//sprawdzenie czy gra skonczona
			int[] zliczenia=new int[3];
			int koniec_kod=silnik.CzyKoniec(zliczenia);
			label5.Text=zliczenia[1].ToString();
			label6.Text=zliczenia[2].ToString();
			if (koniec_kod==2) MessageBox.Show("Obaj gracze nie mog wykona ruchu");
			if (koniec_kod>0)
				{
				//informacja o wygranym
				MessageBox.Show("Wygra gracz "+((zliczenia[1]>zliczenia[2])?"zielony":"brzowy"),"Reversi");
				if (MessageBox.Show(this,"Czy rozpocz gr od nowa?","Reversi",MessageBoxButtons.YesNo,MessageBoxIcon.Question)==DialogResult.Yes)
					{
					//rozpoczecie gry od nowa
					silnik=new ReversiSilnikAI(); //stary obiekt zostanie automatycznie usuniety
					listBox1.Items.Clear();
					listBox2.Items.Clear();
					label5.Text="2";
					label6.Text="2";
					uzgodnijWygladPlanszy();
					}
					else
					{
					this.Close();
					}
				return;
				}

			//sprawdzenie czy kolejny gracz ma mozliwosc ruchu
			if (!silnik.CzyMozliwyRuch())
				{
				MessageBox.Show("Gracz "+((silnik.NumerGraczaWykonujacegoNastepnyRuch()==1)?"zielony":"brzowy")+" zmuszony jest do oddania ruchu");
				silnik.Pass();
				uzgodnijWygladPlanszy();
				}

		}

		private void linkLabel1_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			System.Diagnostics.Process.Start(e.Link.LinkData as string);
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			int[] wspolrzedne=silnik.ProponujNajlepszyRuch();
			kliknieciePolaPlanszy(plansza[wspolrzedne[0],wspolrzedne[1]],e);
		}
	}
}
